unit uCJmainscreen;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls;

type
  RAWrecord = record
    Code    : string[5];
    Job     : shortint;
    Ch      : string[2];
  end;
  CHOICErecord = record
    Code    : string[5];
    RawPtr  : integer;
  end;

type
  TCJmainscreen = class(TForm)
    InputBox: TShape;
    Label2: TLabel;
    Label1: TLabel;
    Shape1: TShape;
    edtInputChar: TLabel;
    edtInput: TEdit;
    labelExact: TLabel;
    btnExactUp: TLabel;
    btnExactDown: TLabel;
    txtDisplay: TLabel;
    btnDisplayUp: TLabel;
    btnDisplayDown: TLabel;
    paneExact: TPanel;
    paneSimiliar: TPanel;
    titleExact: TShape;
    titleDisplay: TShape;
    boxExact: TShape;
    boxDisplay: TShape;
    TimerExact: TTimer;
    TimerSimiliar: TTimer;
    tbStart: TTrackBar;
    tbEnd: TTrackBar;
    txtStart: TLabel;
    txtEnd: TLabel;
    cbHeadOrder: TCheckBox;
    Panel1: TPanel;
    CopyRight: TLabel;
    imgLogo: TImage;
    txtProgrammer: TLabel;
    timHide: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure edtInputKeyPress(Sender: TObject; var Key: Char);
    procedure edtInputChange(Sender: TObject);
    procedure DisplaySimiliar(k:integer; var PageNbr:integer);
    procedure DisplayExact(k:integer ; var PageNbr:integer);
    procedure btnDisplayDownClick(Sender: TObject);
    procedure btnDisplayUpClick(Sender: TObject);
    procedure btnExactDownClick(Sender: TObject);
    procedure btnExactUpClick(Sender: TObject);
    procedure TimerSimiliarTimer(Sender: TObject);
    procedure TimerExactTimer(Sender: TObject);
    procedure tbStartChange(Sender: TObject);
    procedure tbEndChange(Sender: TObject);
    procedure edtInputEnter(Sender: TObject);
    procedure edtInputKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cbHeadOrderClick(Sender: TObject);
    procedure txtClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure timHideTimer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CJcount : integer;
    Raw          : array [1..14000] of RAWrecord;
    txtSame      : array [1..5] of TLabel;
    txtExact     : array [1..30] of TLabel;
    tailExact    : array [1..30] of TLabel;
    txtSimiliar  : array [1..60] of TLabel;
    nbrSimiliar  : array [1..60] of TLabel;
    tailSimiliar : array [1..60] of TLabel;
    Choice       : array [1..5,1..4000] of CHOICErecord;
    Exact        : array [1..2000] of CHOICErecord;
    ChoiceLen    : array [1..5] of integer;
    ExactLen     : integer;
    ChoiceIdx    : integer;
    ExactIdx     : integer;
  end;

var CJmainscreen: TCJmainscreen;

procedure CreateIt(AppHandle:THandle);
procedure ShowIt(AppHandle:THandle);
procedure CloseIt(AppHandle:THandle);
function  IsValid(prg:string; pw:string):boolean;

implementation

uses ufShowSelectChar;

{$R *.dfm}

var Count : integer;
    dbDatabase,
    dbUserName,
    dbPassword,
    dbHostName:string;
    ss:array [1..20] of string[40];

function  IsValid(prg:string; pw:string):boolean;
begin
  IsValid := true;
end;

procedure CreateIt(AppHandle:THandle);
var s:string;
    cc:integer;
begin
  Count := 0;
  Application.Handle := AppHandle;
  if CJmainScreen = nil then begin
    s := application.Hint;
    cc := 0;
    while pos(' ',s)>0 do begin
      inc(cc);
      ss[cc] := Trim(copy(s, 1, pos(' ',s)));
      delete(s, 1, pos(' ',s));
    end;
    inc(cc);
    ss[cc] := Trim(s);
    dbUserName := ss[1];
    dbPassword := ss[2];
    dbHostName := ss[3];
    dbDatabase := ss[4];
    CJmainscreen := TCJmainscreen.Create(Application);
    ShowSelectChar := TShowSelectChar.Create(Application);
    CJmainscreen.Show;
    CJmainScreen.BringToFront;
  end
  else begin
    CJmainscreen.Show;
    CJmainscreen.BringToFront;
  end;
end;

procedure ShowIt(AppHandle:THandle);
begin
  if CJmainscreen <> nil then begin
    CJmainscreen.Show;
    CJmainscreen.BringToFront;
  end;
end;

procedure CloseIt(AppHandle:THandle);
begin
  if CJmainscreen <> nil then begin
    ShowSelectChar.Free;
    CJmainscreen.Free;
    CJmainScreen := nil;
    ShowSelectChar := nil;
  end;
end;

procedure TCJmainscreen.FormCreate(Sender: TObject);
var i:integer;
    CJfile:textfile;
    s2:string[2];
    fs:string;
begin
  if Tag = 0 then begin
    Tag := 1;
    Width := paneSimiliar.Left + paneSimiliar.Width + 9;
//    Height := CopyRight.Top + CopyRight.Height + 35;
    Left := (Screen.Width - Width) div 2;
    Top  := (Screen.Height - Height) div 2 - 2;
    CJcount := 0;
//    fs := ss[12]+'SupportFile_CJ3.txt';
    fs := 'SupportFile_CJ3.txt';
  //  ShowMessage(fs);
    AssignFile(CJfile, fs);
    Reset(CJfile);
    CJcount := 0;
    timHide.Enabled := True;
    while not Eof(CJfile) do begin
      inc(CJcount);
      Read(CJfile, Raw[CJcount].Ch);
      Read(CJfile, s2);
      if s2[2] = ' '  then s2 := s2[1];
      Raw[CJcount].Job := StrToInt(S2);
      ReadLn(CJfile, Raw[CJcount].Code);
    end;
  //  OptCount[0] := CJcount;
    CloseFile(CJfile);
    for i := 1 to 30 do begin
      txtExact[i] := TLabel.Create(Self);
      with txtExact[i] do begin
        Font.Name   := 'sө';
        Font.Size   := 20;
        Font.Color  := clBlue;
        Caption     := '';
        Left        := (i - 1) mod 3 * 90;
        Top         := (i - 1) div 3 * 30;
        Transparent := true;
        Parent      := paneExact;
        OnClick     := txtClick;
      end;
      tailExact[i] := TLabel.Create(Self);
      with tailExact[i] do begin
        Font.Name   := 'Arial';
        Font.Size   := 12;
        Font.Color  := clNavy;
        Caption     := '';
        Left        := (i - 1) mod 3 * 90 + 28;
        Top         := (i - 1) div 3 * 30 + 6;
        Transparent := true;
        Parent      := paneExact;
        OnClick     := txtClick;
      end;
    end;
    for i := 1 to 60 do begin
      txtSimiliar[i] := TLabel.Create(Self);
      with txtSimiliar[i] do begin
        Font.Name   := 'sө';
        Font.Size   := 20;
        Font.Color  := clBlue;
        Caption     := '';
        Left        := (i - 1) mod 6 * 90;
        Top         := (i - 1) div 6 * 30;
        Transparent := true;
        Parent      := paneSimiliar;
        OnClick     := txtClick;
      end;
      nbrSimiliar[i]  := TLabel.Create(Self);
      with nbrSimiliar[i] do begin
        Font.Name   := 'Arial';
        Font.Size   := 9;
        Font.Color  := clNavy;
        Caption     := '';
        Left        := (i - 1) mod 6 * 90 + 28;
        Top         := (i - 1) div 6 * 30;
        Transparent := true;
        Parent      := paneSimiliar;
      end;
      tailSimiliar[i] := TLabel.Create(Self);
      with tailSimiliar[i] do begin
        Font.Name   := 'Arial';
        Font.Size   := 11;
        Font.Color  := clNavy;
        Caption     := '';
        Left        := (i - 1) mod 6 * 90 + 28;
        Top         := (i - 1) div 6 * 30 + 12;
        Transparent := true;
        Parent      := paneSimiliar;
      end;
    end;
    for i := 1 to 5 do begin
      txtSame[i] := TLabel.Create(Self);
      with txtSame[i] do begin
        Font.Name   := 'з';
        Font.Size   := 24;
        Font.Color  := clRed;
        Caption     := '';
        Left        := i * 40 + 380;
        Top         := 7;
        Transparent := true;
        Parent      := Self;
        OnClick     := txtClick;
        BringToFront;
      end;
    end;
    txtSimiliar[1].Caption := '̤֤@X';
    txtExact[1].Caption := '̤֨X';
  end;
end;

procedure TCJmainscreen.edtInputKeyPress(Sender: TObject; var Key: Char);
begin
  case Key of
    #8,'A'..'Y':;
    'a'..'y':Key := Chr(ord(Key)+ord('A')-ord('a'));
    else Key := #0;
  end;
  case Key of
    #8:;//ShowMessage(IntToStr(StrToInt(Key)));
    'A'..'Z':begin
               edtInput.Text := edtInput.Text + Key;
               Key := #0;
             end;
  end;
end;

procedure TCJmainscreen.edtInputChange(Sender: TObject);
var i,k,z:integer;
    s:string[5];
    f:boolean;
begin
  TimerSimiliar.Enabled := false;
  TimerExact.Enabled    := false;
  edtInput.OnChange     := nil;    // ensure max length is 5
  s                     := edtInput.Text;
  edtInput.Text         := s;
  edtInput.OnChange     := edtInputChange;
  edtInputChar.Caption  := s;
  k := length(edtInput.Text);
  for i := 1 to 5 do txtSame[i].Caption := '';
  case k of
    1:begin
        ChoiceLen[1] := 0;
        ExactLen     := 0;
        z            := 0;
        for i := 1 to CJcount do begin
          if cbHeadOrder.Checked
          then f := (s[1] = Raw[i].Code[1])
          else f := (pos(s[1], Raw[i].Code) > 0);
          if f
          and (Raw[i].Job >= tbStart.Position)
          and (Raw[i].Job <= tbEnd.Position) then begin
            inc(ChoiceLen[1]);
            Choice[1,ChoiceLen[1]].RawPtr := i;
            Choice[1,ChoiceLen[1]].Code   := Raw[i].Code;
            delete(Choice[1,ChoiceLen[1]].Code, pos(s[1],Choice[1,ChoiceLen[1]].Code), 1);
            if edtInput.Text = Raw[i].Code then begin
              inc(z);
              txtSame[z].Caption := Raw[i].Ch;
            end;
          end;
        end;
      end; { end case 1 }
    2..5:begin
           ChoiceLen[k] := 0;
           ExactLen     := 0;
           z            := 0;
           for i := 1 to ChoiceLen[k-1] do begin
             if cbHeadOrder.Checked
             then f := (s = Copy(Raw[Choice[k-1,i].RawPtr].Code,1,k))
             else f := (pos(s[k], Choice[k-1,i].Code) > 0);
             if  f
             and (Raw[Choice[k-1,i].RawPtr].Job >= tbStart.Position)
             and (Raw[Choice[k-1,i].RawPtr].Job <= tbEnd.Position) then begin
               inc(ChoiceLen[k]);
               Choice[k,ChoiceLen[k]].RawPtr := Choice[k-1,i].RawPtr;
               Choice[k,ChoiceLen[k]].Code := Choice[k-1,i].Code;
               delete(Choice[k,ChoiceLen[k]].Code, pos(s[k],Choice[k,ChoiceLen[k]].Code), 1);
               if pos(s, Raw[Choice[k, ChoiceLen[k]].RawPtr].Code) > 0 then begin
                 inc(ExactLen);
                 Exact[ExactLen].RawPtr := Choice[k,ChoiceLen[k]].RawPtr;
                 Exact[ExactLen].Code   := Raw[Choice[k,ChoiceLen[k]].RawPtr].Code;
                 if edtInput.Text = Raw[Choice[k,ChoiceLen[k]].RawPtr].Code then begin
                   inc(z);
                   txtSame[z].Caption := Raw[Choice[k,ChoiceLen[k]].RawPtr].Ch;
                 end;
               end;
             end;
           end;
         end;
    else ;
  end;
  ChoiceIdx := 0;
  ExactIdx  := 0;
  TimerSimiliar.Enabled := true;
  TimerExact.Enabled    := true;
  edtInput.Left := edtInputChar.Left+edtInputChar.Width;
end;

procedure TCJmainscreen.DisplaySimiliar(k:integer; var PageNbr:integer);
const pItem = 60;
var   j,z:integer;
begin
  if k = 0 then begin
    for j := 1 to pItem do begin
      txtSimiliar[j].Caption  := '';
      nbrSimiliar[j].Caption  := '';
      tailSimiliar[j].Caption := '';
    end;
    txtSimiliar[1].Caption := '̤֤@X';
    exit;
  end;
  if PageNbr < 0 then PageNbr := 0;
  if (PageNbr*pItem-1) > ChoiceLen[k] then PageNbr := (ChoiceLen[k] - 1) div pItem;
  z := 0;
  for j := PageNbr*pItem+1 to (PageNbr+1)*pItem do begin
    if j <= ChoiceLen[k] then begin
      inc(z);
      txtSimiliar[z].Caption  := Raw[Choice[k, j].RawPtr].Ch;
      nbrSimiliar[z].Caption  := IntToStr(Raw[Choice[k, j].RawPtr].Job);
      tailSimiliar[z].Caption := Raw[Choice[k, j].RawPtr].Code;
    end
    else begin
      inc(z);
      txtSimiliar[z].Caption  := '';
      nbrSimiliar[z].Caption  := '';
      tailSimiliar[z].Caption := '';
    end;
  end;
end;

procedure TCJmainscreen.DisplayExact(k:integer; var PageNbr:integer);
const pItem = 30;
var   j,z:integer;
  procedure ClearAll;
  var i:integer;
  begin
    for i := 1 to 30 do txtExact[i].Caption     := '';
    for i := 1 to 30 do tailExact[i].Caption    := '';
  end;
begin
  ClearAll;
  if k in [0,1] then begin
    for j := 1 to pItem do begin
      txtExact[j].Caption  := '';
      tailExact[j].Caption := '';
    end;
    txtExact[1].Caption := '̤֨X';
    exit;
  end;
  if PageNbr < 0 then PageNbr := 0;
  if (PageNbr*pItem-1) > ExactLen then PageNbr := (ExactLen - 1) div pItem;
  z := 0;
  for j := PageNbr*pItem+1 to (PageNbr+1)*pItem do if j <= ExactLen then begin
    inc(z);
    txtExact[z].Caption  := Raw[Exact[j].RawPtr].Ch;
    tailExact[z].Caption := Raw[Exact[j].RawPtr].Code;
  end;
end;

procedure TCJmainscreen.btnDisplayDownClick(Sender: TObject);
begin
  inc(ChoiceIdx);
  TimerSimiliar.Enabled := true;
end;

procedure TCJmainscreen.btnDisplayUpClick(Sender: TObject);
begin
  dec(ChoiceIdx);
  TimerSimiliar.Enabled := true;
end;

procedure TCJmainscreen.btnExactDownClick(Sender: TObject);
begin
  inc(ExactIdx);
  TimerExact.Enabled := true;
end;

procedure TCJmainscreen.btnExactUpClick(Sender: TObject);
begin
  dec(ExactIdx);
  TimerExact.Enabled := true;
end;

procedure TCJmainscreen.TimerSimiliarTimer(Sender: TObject);
begin
  TimerSimiliar.Enabled := false;
  DisplaySimiliar(length(edtInput.Text), ChoiceIdx);
end;

procedure TCJmainscreen.TimerExactTimer(Sender: TObject);
begin
  TimerExact.Enabled := false;
  DisplayExact(length(edtInput.Text), ExactIdx);
end;

procedure TCJmainscreen.tbStartChange(Sender: TObject);
var s  :string;
    i,k:integer;
begin
  tbStart.OnChange := nil;
  if tbStart.Position > tbEnd.Position then begin
    tbEnd.OnChange := nil;
    tbEnd.Position := tbStart.Position;
    txtEnd.Caption := IntToStr(tbEnd.Position);
    tbEnd.OnChange := tbEndChange;
  end;
  edtInput.SetFocus;
  txtStart.Caption := IntToStr(tbStart.Position);
  s := edtInput.Text;
  k := length(s);
  edtInput.Text := '';
  for i := 1 to k do begin
    edtInput.Text := edtInput.Text + s[i];
    edtInputChange(edtInput);
  end;
  tbStart.OnChange := tbStartChange;
end;

procedure TCJmainscreen.tbEndChange(Sender: TObject);
var s  :string;
    i,k:integer;
begin
  tbEnd.OnChange := nil;
  if tbStart.Position > tbEnd.Position then begin
    tbStart.OnChange := nil;
    tbStart.Position := tbEnd.Position;
    txtStart.Caption := IntToStr(tbStart.Position);
    tbStart.OnChange := tbStartChange;
  end;
  edtInput.SetFocus;
  txtEnd.Caption := IntToStr(tbEnd.Position);
  s := edtInput.Text;
  k := length(s);
  edtInput.Text := '';
  for i := 1 to k do begin
    edtInput.Text := edtInput.Text + s[i];
    edtInputChange(edtInput);
  end;
  tbEnd.OnChange := tbEndChange;
end;

procedure TCJmainscreen.edtInputEnter(Sender: TObject);
var K:char;
begin
  edtInput.SelectAll;
  K := #35;
  edtInput.OnKeyPress(edtInput, K);
end;

procedure TCJmainscreen.edtInputKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var s:string;
begin
  if Key = 8 then begin
    Key := 0;
    s := edtInput.Text;
    if length(S) > 0 then edtInput.Text := Copy(s,1,length(s)-1); 
  end;
end;

procedure TCJmainscreen.cbHeadOrderClick(Sender: TObject);
begin
  edtInput.SetFocus;
  edtInputChange(edtInput);
end;

procedure TCJmainscreen.timHideTimer(Sender: TObject);
begin
  timHide.Enabled := False;
  imgLogo.Visible := False;
  txtProgrammer.Visible := False;
end;

procedure TCJmainscreen.txtClick(Sender: TObject);
begin
  ShowSelectChar.pubCaption := TLabel(Sender).Caption;
  ShowSelectChar.Left := Self.Left+paneExact.Left;
  ShowSelectChar.Top  := self.Top+paneExact.Top+30;
  ShowSelectChar.Width := paneExact.Width+4;
  ShowSelectChar.Height := paneExact.Height;

  ShowSelectChar.Show;
end;

procedure TCJmainscreen.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ShowSelectChar.Close;
  Hide;
end;

end.
